using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
		      int a;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               pdf.SaveGraphicState();
                  pdf.SetGStateFlags(TGStateFlags.gfRealTopDownCoords, false); // This simplifies the handling a little bit.
                  pdf.RotateCoords(-30, 50.0, 200.0);

                  String text = "Some rotated text on a page...";
                  pdf.SetFont("Helvetica", TFStyle.fsRegular, 20.0, false, TCodepage.cp1252);

                  float d = (float)pdf.GetDescent();
                  float w = (float)pdf.GetTextWidth(text);

                  // Highlight annotations do not consider coordinate transformations made on a page.
                  // To get such annotations rotated we must set the annotation's quad points.
                  // SetAnnotQuadPoints() considers transformations of the coordinate system.

                  pdf.WriteText(0.0, 0.0, text);
                  a = pdf.HighlightAnnot(TAnnotType.atHighlight, 50.0, 50.0 + d, w, 20.0, CPDF.PDF_YELLOW, "Test app", "Highligh Annotations", "This is a highlight annotation");
                  TFltPoint[] points = new TFltPoint[4];
                  // Consider the unusual order of the points!
                  points[0].x = 0.0f;      // x1 -> Top left corner
                  points[0].y = d;         // y1 -> Top left corner
                  points[1].x = w;         // x2 -> Top right corner
                  points[1].y = d;         // y2 -> Top right corner
                  points[2].x = 0.0f;      // x3 -> Bottom left corner
                  points[2].y = 20.0f + d; // y3 -> Bottom left corner
                  points[3].x = w;         // x4 -> Bottom right corner
                  points[3].y = 20.0f + d; // y4 -> Bottom right corner
                  pdf.SetAnnotQuadPoints(a, points);

                  pdf.WriteText(0.0, 30.0, text);
                  a = pdf.HighlightAnnot(TAnnotType.atSquiggly, 50.0, 80.0, w, 20.0, CPDF.PDF_RED, "Test app", "Squiggly Annotations", "This is a squiggly annotation");
                  // Update the y-coordinates
                  points[0].y += 30.0f;
                  points[1].y += 30.0f;
                  points[2].y += 30.0f;
                  points[3].y += 30.0f;
                  pdf.SetAnnotQuadPoints(a, points);

                  pdf.WriteText(0.0, 60.0, text);
                  a = pdf.HighlightAnnot(TAnnotType.atStrikeOut, 50.0, 110.0, w, 20.0, CPDF.PDF_RED, "Test app", "Strikeout Annotations", "This is a strikeout annotation");
                  // Update the y-coordinates
                  points[0].y += 30.0f;
                  points[1].y += 30.0f;
                  points[2].y += 30.0f;
                  points[3].y += 30.0f;
                  pdf.SetAnnotQuadPoints(a, points);

                  pdf.WriteText(0.0, 90.0, text);
                  a = pdf.HighlightAnnot(TAnnotType.atUnderline, 50.0, 140.0, w, 20.0, CPDF.PDF_RED, "Test app", "Underline Annotations", "This is a underline annotation");
                  // Update the y-coordinates
                  points[0].y += 30.0f;
                  points[1].y += 30.0f;
                  points[2].y += 30.0f;
                  points[3].y += 30.0f;
                  pdf.SetAnnotQuadPoints(a, points);

                  text = "Link annotations support quad points too";
                  w = (float)pdf.GetTextWidth(text);
                  pdf.WriteText(0.0, 120.0, text);
                  // Link annotations support quad points too.
                  a = pdf.WebLink(0.0, 120.0, w, 20, "www.dynaforms.com");
                  pdf.SetAnnotBorderWidth(a, 1.0);
                  pdf.SetAnnotColor(a, TAnnotColor.acBorderColor, TPDFColorSpace.csDeviceRGB, CPDF.PDF_BLUE);
                  points[0].x = 0.0f;       // x1 -> Top left corner
                  points[0].y = 120.0f + d; // y1 -> Top left corner
                  points[1].x = w;          // x2 -> Top right corner
                  points[1].y = 120.0f + d; // y2 -> Top right corner
                  points[2].x = 0.0f;       // x3 -> Bottom left corner
                  points[2].y = 140.0f + d; // y3 -> Bottom left corner
                  points[3].x = w;          // x4 -> Bottom right corner
                  points[3].y = 140.0f + d; // y4 -> Bottom right corner
                  pdf.SetAnnotQuadPoints(a, points);
               pdf.RestoreGraphicState();
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process pcs = new System.Diagnostics.Process();
                  pcs.StartInfo.FileName = filePath;
                  pcs.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
